********************************************************************************
* PROGRAMMER: DOS
* PROJECT:    EANNA 2023
* PURPOSE:    Indicador de Trabajo Infantil 2023
* LAST UPDATE:Diciembre 2024
* INPUT:      BASE EANNA 2023
********************************************************************************
drop ti tfp tsnr ti_tfp ti_tbem ti_tp tp_1 tp_2 tp_3 tp_4 tp_5 tp_6 tp_7 ti_tsnrp ti_hpc

***********************************************************************
* SECCION TRABAJO INFANTIL
*A) TRABAJO BAJO LA EDAD MINIMA (TBEM) 
***********************************************************************
*sumar tiempo de actividad modulo AE con actividades de modulo TH
egen t_th_ae=rsum(tt_h_volb tt_h_autb tt_h_ocu tt_e) if (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1)  , missing	//sumar tiempo AE y TH
egen 	tt_autb=rsum(tt_e tt_h_autb) 				 if (inrange(ab_principal,1,77) | ab_unica==1), missing 			//sumar tiempo AE y TH 
egen 	tt_volb=rsum(tt_e tt_h_volb) 				 if (inrange(vb_principal,1,77) | vb_unica==1), missing 			//sumar tiempo AE y TH 
egen 	tt_ocu=rsum(tt_e tt_h_ocu) 				 	 if (inrange(o_principal,1,77)  | o_unica==1) , missing				//sumar tiempo AE y TH

gen 	ti_tbem=0 if nna_selec==1  & inrange(edad_grupo,1,2)																						//5 a 14
replace ti_tbem=1 if edad_grupo==2 & ((t_th_ae>=1 & t_th_ae!=.) | (tt_ocu>=1 & tt_ocu!=.) | (tt_autb>=1 & tt_autb!=.) | (tt_volb>=1 & tt_volb!=.))	//9 a 14 trabaja al menos una hora
replace ti_tbem=1 if edad_grupo==1 & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1)															//5 a 8 realiza actividad modulo actividades economicas
replace ti_tbem=1 if edad_grupo==2 & (inrange(ocupacion,1,2) | inrange(autoconsumo_b,1,2) | inrange(voluntario_b,1,2))								//9 a 14 trabaja al menos una hora

label variable ti_tbem "Trabajo infantil por TFP: Bajo la edad mínima (5 a 14)"
label values ti_tbem ti_tbem
***********************************************************************
*B) TRABAJO PELIGROSO (TP - 7 categorias)
***********************************************************************
*tp1 - trabajo peligroso por herramientas o elementos peligrosos (15 a 17) 
***********************************************************************
*herramientas
gen 	aux1=1 if (a58==1 |a59==1) & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) //variable auxiliar para uso de herramientas		
replace aux1=0 if (a58==2 &a59==2) & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) //variable auxiliar para uso de herramientas

*elementos peligrosos (armas o explosivos, sustancias quimicas, herramientas afiladas, hornos, sopletes) 
gen 	aux2=1 if a60_1==1 			  	& (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) 									//variable auxiliar para uso de elementos
replace	aux2=1 if (a14_1a==1|a14_1b==1) & (ocupacion==2 | autoconsumo_b==2 | voluntario_b==2) & (tt_cocina>=1 &tt_cocina!=.)	//variable auxiliar para uso de elementos (cocina al menos una hora para que uso sea peligroso)
replace aux2=0 if a60_1==2 				& (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) 									//variable auxiliar para uso de elementos
replace	aux2=0 if (a14_1a==2&a14_1b==2) & (ocupacion==2 | autoconsumo_b==2 | voluntario_b==2) & (tt_cocina<1 &tt_cocina!=.)		//variable auxiliar para uso de elementos

*toxico //recoger basura
gen 	aux3=1 if a62_3==1 & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) 			//variable auxiliar actividad toxica
replace aux3=0 if a62_3==2 & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1)			//variable auxiliar actividad toxica

*se suman herramientas y elementos
gen 	tp_1=0 if nna_selec==1 & edad_grupo==3												//TP por uso de herramientas o elementos peligrosos (15 a 17)
replace tp_1=1 if (aux1==1 | aux2==1 | aux3==1 ) & edad_grupo==3							//TP por uso de herramientas o elementos peligrosos (15 a 17)
drop aux*

*label
label variable tp_1 "TP por uso de herramientas o elementos peligrosos (15 a 17)"
label values tp_1 tp_1
***********************************************************************
*tp2 - Cargas pesadas (15 a 17) 
***********************************************************************
gen 	tp_2=0 if nna_selec==1 & edad_grupo==3													//TP por manipulación de cargas pesadas (15 a 17)
replace	tp_2=1 if a57==1 & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1 ) & edad_grupo==3	//TP por manipulación de cargas pesadas (15 a 17)

*label
label variable tp_2 "TP por manipulación de cargas pesadas (15 a 17)"
label values tp_2 tp_2
***********************************************************************
*tp3 - lugares peligrosos (15 a 17) //(calle,frio,calor,polvo,ruido,altura,bajo tierra,agua,animales ganado,repetitivas,alcohol,dinero) 
*a32_3 pregunta por lugar en la calle pero tambien incluye feria, se decide junto a la MT no incluir
***********************************************************************
gen		tp_3=0 if nna_selec==1 & edad_grupo==3 		//TP por lugares o actividades peligrosas (15 a 17)
replace	tp_3=1 if (a27_1==1|a28_1_1==1|a61_1==1|a61_2==1|a61_4==1|a61_5==1|a62_1==1|a62_2==1|a62_4==1|a62_5==1|a62_7==1|a62_8==1|a62_9==1) & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) & edad_grupo==3 //TP por lugares o actividades peligrosas (15 a 17)

*label
label variable tp_3 "TP por lugares o actividades peligrosas (15 a 17)"
label values tp_3 tp_3
**********************************************************************
*tp4 - horario prolongando (15 a 17) 
*limite de horas
***********************************************************************
*FP limite_hrs1 - limite_hrs5
*FP 15-17 [MODULO ACTIVIDADES ECONOMICAS]
gen		limite_hrs1=1 if ((tt_e>30 & tt_e!=.) | (td_e>8 & td_e!=.))	& (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) & vacaciones==1 & edad_grupo==3	//limite horario periodo vacaciones FP modulo AE
replace limite_hrs1=1 if ((tt_e>30 & tt_e!=.) | (td_e>6 & td_e!=.))	& (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) & vacaciones==0 & edad_grupo==3	//limite horario periodo normal FP modulo AE
replace limite_hrs1=0 if ((tt_e<=30 & tt_e!=.) & td_e<=8) 			& (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) & vacaciones==1 & edad_grupo==3	//limite horario periodo vacaciones FP modulo AE
replace limite_hrs1=0 if ((tt_e<=30 & tt_e!=.) & td_e<=6) 			& (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) & vacaciones==0 & edad_grupo==3	//limite horario periodo normal FP modulo AE
*FP 15-17 [MODULO TAREAS DEL HOGAR] OCUPACION
gen		limite_hrs2=1 if ((tt_h_ocu>30 & tt_h_ocu!=.) | (td_h_ocu>8 & td_h_ocu!=.))	& ocupacion==2 & vacaciones==1 & edad_grupo==3							//limite horario periodo vacaciones FP modulo TH (ocupacion)
replace limite_hrs2=1 if ((tt_h_ocu>30 & tt_h_ocu!=.) | (td_h_ocu>6 & td_h_ocu!=.))	& ocupacion==2 & vacaciones==0 & edad_grupo==3							//limite horario periodo normal FP modulo TH (ocupacion)
replace limite_hrs2=0 if ((tt_h_ocu<=30 & tt_h_ocu!=.) & td_h_ocu<=8) 				& ocupacion==2 & vacaciones==1 & edad_grupo==3							//limite horario periodo vacaciones FP modulo TH (ocupacion)
replace limite_hrs2=0 if ((tt_h_ocu<=30 & tt_h_ocu!=.) & td_h_ocu<=6) 				& ocupacion==2 & vacaciones==0 & edad_grupo==3							//limite horario periodo normal FP modulo TH (ocupacion)
*FP 15-17 [MODULO TAREAS DEL HOGAR] AUTOCONSUMO
gen		limite_hrs3=1 if ((tt_h_autb>30 & tt_h_autb!=.) | (td_h_autb>8 & td_h_autb!=.))	& autoconsumo_b==2 & vacaciones==1 & edad_grupo==3					//limite horario periodo vacaciones FP modulo TH (autoconsumo bienes)
replace limite_hrs3=1 if ((tt_h_autb>30 & tt_h_autb!=.) | (td_h_autb>6 & td_h_autb!=.))	& autoconsumo_b==2 & vacaciones==0 & edad_grupo==3					//limite horario periodo normal FP modulo TH (autoconsumo bienes)
replace limite_hrs3=0 if ((tt_h_autb<=30 & tt_h_autb!=.) & td_h_autb<=8) 				& autoconsumo_b==2 & vacaciones==1 & edad_grupo==3					//limite horario periodo vacaciones FP modulo TH (autoconsumo bienes)
replace limite_hrs3=0 if ((tt_h_autb<=30 & tt_h_autb!=.) & td_h_autb<=6) 				& autoconsumo_b==2 & vacaciones==0 & edad_grupo==3					//limite horario periodo normal FP modulo TH (autoconsumo bienes)
*FP 15-17 [MODULO TAREAS DEL HOGAR] VOLUNTARIO
gen		limite_hrs4=1 if ((tt_h_volb>30 & tt_h_volb!=.) | (td_h_volb>8 & td_h_volb!=.))	& voluntario_b==2 & vacaciones==1 & edad_grupo==3					//limite horario periodo vacaciones FP modulo TH (voluntario bienes)
replace limite_hrs4=1 if ((tt_h_volb>30 & tt_h_volb!=.) | (td_h_volb>6 & td_h_volb!=.))	& voluntario_b==2 & vacaciones==0 & edad_grupo==3					//limite horario periodo normal FP modulo TH (voluntario bienes)
replace limite_hrs4=0 if ((tt_h_volb<=30 & tt_h_volb!=.) & td_h_volb<=8) 				& voluntario_b==2 & vacaciones==1 & edad_grupo==3					//limite horario periodo vacaciones FP modulo TH (voluntario bienes)
replace limite_hrs4=0 if ((tt_h_volb<=30 & tt_h_volb!=.) & td_h_volb<=6) 				& voluntario_b==2 & vacaciones==0 & edad_grupo==3					//limite horario periodo normal FP modulo TH (voluntario bienes)
*FP 15-17 [SUMA AE Y TH] //suma de modulos solo hora a la semana, no se puede por dia // tt_h_volb tt_h_autb tt_h_ocu tt_e
gen		limite_hrs5=1 if ((t_th_ae>30 & t_th_ae!=.) | (tdmax_h_ocu>8 & tdmax_h_ocu!=.) | (tdmax_h_autb>8 & tdmax_h_autb!=.) | (tdmax_h_volb>8 & tdmax_h_volb!=.))& vacaciones==1 & edad_grupo==3	//limite horario periodo vacaciones FP (suma AE y TH)
replace limite_hrs5=1 if ((t_th_ae>30 & t_th_ae!=.) | (tdmax_h_ocu>6 & tdmax_h_ocu!=.) | (tdmax_h_autb>6 & tdmax_h_autb!=.) | (tdmax_h_volb>6 & tdmax_h_volb!=.))& vacaciones==0 & edad_grupo==3	//limite horario periodo normal FP (suma AE y TH)
replace limite_hrs5=0 if ((t_th_ae<=30 & t_th_ae!=.) & tdmax_h_ocu<=8 & tdmax_h_autb<=8 & tdmax_h_volb<=8) 					 									 & vacaciones==1 & edad_grupo==3	//limite horario periodo vacaciones FP (suma AE y TH)
replace limite_hrs5=0 if ((t_th_ae<=30 & t_th_ae!=.) & tdmax_h_ocu<=6 & tdmax_h_autb<=6 & tdmax_h_volb<=6) 					 									 & vacaciones==0 & edad_grupo==3	//limite horario periodo normal FP (suma AE y TH)


*FGP limite_hrs6 - limite_hrs11 (NO DIFERENCIA ENTRE PERIODO NORMAL Y VACACIONES)
*FGP 15-17 [MODULO ACTIVIDADES ECONOMICAS] 
gen		limite_hrs6=1 if (tt_e>30 & tt_e!=.)			& tsnr1==1 & edad_grupo==3	//limite horario tsnr 15 a 17 modulo AE
replace limite_hrs6=0 if (tt_e<=30& tt_e!=.)			& tsnr1==1 & edad_grupo==3	//limite horario tsnr 15 a 17 modulo AE
*FGP 15-17 [MODULO TAREAS DEL HOGAR]
gen		limite_hrs7=1 if (tt_h_tsnr>30 & tt_h_tsnr!=.)	& tsnr2==1 & edad_grupo==3	//limite horario tsnr 15 a 17 modulo TH
replace limite_hrs7=0 if (tt_h_tsnr<=30& tt_h_tsnr!=.)	& tsnr2==1 & edad_grupo==3	//limite horario tsnr 15 a 17 modulo TH
*FGP 15-17 [SUMA MODULOS CUANDO AE ES tsnr]
gen		limite_hrs8=1 if (tt_tsnr>30 & tt_tsnr!=.)		& tsnr2==1 & edad_grupo==3	//limite horario tsnr 15 a 17 suma modulo TH y AE
replace limite_hrs8=0 if (tt_tsnr<=30 & tt_tsnr!=.)		& tsnr2==1 & edad_grupo==3	//limite horario tsnr 15 a 17 suma modulo TH y AE


*FGP 9-14 [MODULO ACTIVIDADES ECONOMICAS]
gen		limite_hrs9=1 if (tt_e>21 & tt_e!=.)			& tsnr1==1 & edad_grupo==2	//limite horario tsnr 9 a 14 modulo AE
replace limite_hrs9=0 if (tt_e<=21  & tt_e!=.)			& tsnr1==1 & edad_grupo==2	//limite horario tsnr 9 a 14 modulo AE
*FGP 9-14 [MODULO TAREAS DEL HOGAR]
gen		limite_hrs10=1 if (tt_h_tsnr>21 & tt_h_tsnr!=.)	& tsnr2==1 & edad_grupo==2	//limite horario tsnr 9 a 14 modulo TH
replace limite_hrs10=0 if (tt_h_tsnr<=21 & tt_h_tsnr!=.)& tsnr2==1 & edad_grupo==2	//limite horario tsnr 9 a 14 modulo TH
*FGP 9-14 [SUMA MODULOS CUANDO AE ES tsnr]
gen		limite_hrs11=1 if (tt_tsnr>21 & tt_tsnr!=.)		& tsnr2==1 & edad_grupo==2	//limite horario tsnr 9 a 14 suma modulo TH y AE
replace limite_hrs11=0 if (tt_tsnr<=21 & tt_tsnr!=.)	& tsnr2==1 & edad_grupo==2	//limite horario tsnr 9 a 14 suma modulo TH y AE

*HORARIO PROLONGADO 
gen 	tp_4=0 if nna_selec==1 & edad_grupo==3															//TP por horario prolongado (15 a 17)
replace tp_4=1 if (limite_hrs1==1 | limite_hrs2==1 | limite_hrs3==1 | limite_hrs4==1 | limite_hrs5==1)	//TP por horario prolongado (15 a 17)

*label
label variable tp_4 "TP por horario prolongado (15 a 17)"
label values tp_4 tp_4
***********************************************************************
*tp5 - horarios nocturnos (15 a 17) 
***********************************************************************
gen 	tp_5=0 if  nna_selec==1 & edad_grupo==3																						//TP por horario nocturno (15 a 17)
replace tp_5=1 if (a43a_3==1|a43b_3==1|a44a_3==1|a44b_3==1) & (ocupacion==1 | autoconsumo_b==1 | voluntario_b==1) & edad_grupo==3	//TP por horario nocturno (15 a 17)

*label
label variable tp_5 "TP por horario nocturno (15 a 17)"
label values tp_5 tp_5
***********************************************************************
*tp6 - oficio peligroso (15 a 17) 
***********************************************************************
gen tp6aux=.  
replace tp6aux=0 if (ocupacion==1|autoconsumo_b==1|voluntario_b==1) & inlist(a30_cod,-98,-89) & edad_grupo==3 											//2 casos sin dato NS/NR
replace tp6aux=0 if (ocupacion==1|autoconsumo_b==1|voluntario_b==1) & inlist(a30_cod,41,43,44,51,52,61,63,71,73,75,91,92,93,94,95,96) & edad_grupo==3	//oficios considerados no peligrosos 
replace tp6aux=1 if (ocupacion==1|autoconsumo_b==1|voluntario_b==1) & inlist(a30_cod,53,54,62,72,74,81,82,83) & edad_grupo==3							//directo
replace tp6aux=1 if folio=="EANNA_03369"  & a30_cod==51 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_0670"   & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_01125"  & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_02682"  & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_03370"  & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_04082"  & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_04337"  & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_05606"  & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_07563"  & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_010232" & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_012993" & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_011351" & a30_cod==52 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09748"  & a30_cod==52 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_013432" & a30_cod==61 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_013450" & a30_cod==61 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_016179" & a30_cod==61 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_017458" & a30_cod==61 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_03446"  & a30_cod==61 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_04296"  & a30_cod==61 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_05578"  & a30_cod==61 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09555"  & a30_cod==61 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_02010"  & a30_cod==71 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_02435"  & a30_cod==71 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_07976"  & a30_cod==71 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_07406"  & a30_cod==73 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_04856"  & a30_cod==75 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_05421"  & a30_cod==75 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_010050" & a30_cod==75 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_014757" & a30_cod==75 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_016407" & a30_cod==75 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_014253" & a30_cod==75 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_01183"  & a30_cod==91 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_07150"  & a30_cod==91 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09273"  & a30_cod==91 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09971"  & a30_cod==91 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_016123" & a30_cod==91 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_017168" & a30_cod==91 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09360"  & a30_cod==91 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_05435"  & a30_cod==92 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09727"  & a30_cod==92 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_011879" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_06474"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_012431" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_012649" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_012910" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_013053" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_013603" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_014527" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_015132" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_015420" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_015504" & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_02370"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_03467"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_0468"   & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_05247"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_05360"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_07331"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_09051"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_0427"   & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_04613"  & a30_cod==92 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_0968"   & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_0974"   & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_04972"  & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_05035"  & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_08290"  & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_08492"  & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09934"  & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_013027" & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_014543" & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_014805" & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_015701" & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_016101" & a30_cod==93 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_013665" & a30_cod==93 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_017155" & a30_cod==93 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_02693"  & a30_cod==93 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_06418"  & a30_cod==93 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_015314" & a30_cod==93 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_04366"  & a30_cod==93 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_06181"  & a30_cod==93 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_07051"  & a30_cod==94 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_09121"  & a30_cod==94 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_012804" & a30_cod==94 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_015465" & a30_cod==95 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_011545" & a30_cod==96 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_012711" & a30_cod==96 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_015401" & a30_cod==96 & edad_grupo==3
replace tp6aux=1 if folio=="EANNA_010360" & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_011753" & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_013917" & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_01735"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_02017"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_03216"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_04202"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_07667"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_07957"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_012634" & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_014606" & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_04759"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_05520"  & a30_cod==96 & edad_grupo==3 
replace tp6aux=1 if folio=="EANNA_09468"  & a30_cod==96 & edad_grupo==3 

gen 	tp_6=0 if nna_selec==1 & edad_grupo==3													//TP por oficios peligrosos (15 a 17)
replace tp_6=1 if tp6aux==1 & (ocupacion==1|autoconsumo_b==1|voluntario_b==1) & edad_grupo==3	//TP por oficios peligrosos (15 a 17)
drop tp6aux

*label
label variable tp_6 "TP por oficios peligrosos (15 a 17)"
label values tp_6 tp_6

***********************************************************************
*tp7 - riesgo de abandono escolar (15 a 17) 
***********************************************************************
gen 	tp_7=0 if nna_selec==1 & edad_grupo==3
replace	tp_7=1 if (inrange(ocupacion,1,2) |inrange(autoconsumo_b,1,2) |inrange(voluntario_b,1,2)) 	& (a2==3 | inlist(a4,1,3)) & edad_grupo==3	//TP por riesgo de abandono escolar (15 a 17)
replace	tp_7=1 if (inrange(ocupacion,1,2) | inrange(autoconsumo_b,1,2) | inrange(voluntario_b,1,2)) 	& n4==3 & edad_grupo==3					//TP por riesgo de abandono escolar (15 a 17)

*label
label variable tp_7 "TP por riesgo de abandono escolar (15 a 17)"
label values tp_7 tp_7

***********************************************************************
*B) TRABAJO PELIGROSO (15 a 17)  (tp1+tp2+tp3+tp4+tp5+tp6+tp7)
***********************************************************************
gen 	ti_tp=0 if nna_selec==1 & edad_grupo==3 																																	//Trabajo infantil por TFP: Trabajo peligroso (15 a 17)
replace ti_tp=1 if (tp_1==1|tp_2==1|tp_3==1|tp_4==1|tp_5==1|tp_6==1|tp_7==1) & (inrange(ocupacion,1,2) | inrange(autoconsumo_b,1,2) | inrange(voluntario_b,1,2)) & edad_grupo==3	//Trabajo infantil por TFP: Trabajo peligroso (15 a 17)

*label
label variable ti_tp "Trabajo infantil por TFP: Trabajo peligroso (15 a 17)"
label values ti_tp ti_tp

***********************************************************************
*C) Trabajo de servicios no remunerado peligroso (5 a 17) 
***********************************************************************
*cocina con elementos peligrosos (tp1_tsnrp cocina al menos una hora) 
gen 	tp1_tsnrp=1 if (a14_1a==1 | a14_1b==1) & (tt_cocina>=1 &tt_cocina!=.)
replace tp1_tsnrp=0 if (a14_1a==2 & a14_1b==2) & (tt_cocina<1 &tt_cocina!=.)

*5 a 8 - trabajo de servicios no remunerado peligroso (5 a 8 años)
replace	tp1_tsnrp=0 if actividad_th==1
replace tp1_tsnrp=1 if actividad_th==1 &(n11_1a==1 |n11_1b==1)

*horario prolongado tsnrp
gen 	tp4_tsnrp=1 if limite_hrs6==1 | limite_hrs7==1 | limite_hrs8==1 | limite_hrs9==1 | limite_hrs10==1 | limite_hrs11==1 
replace tp4_tsnrp=0 if limite_hrs6==0 & limite_hrs7==0 & limite_hrs8==0 & limite_hrs9==0 & limite_hrs10==0 & limite_hrs11==0
*conjunto
gen 	tp4c=1 if tp_4==1 | tp4_tsnrp==1
replace tp4c=0 if tp_4==0 & tp4_tsnrp==0

*riesgo de abandono escolar tsnrp
gen 	tp_7tsnrp=0 if nna_selec==1
replace	tp_7tsnrp=1 if (inrange(autoconsumo_s,1,2) | inrange(voluntario_s,1,2)) 							& (inrange(a2,1,2) | inrange(a4,4,7))
replace	tp_7tsnrp=1 if n11_1==1 																			& inrange(n4,1,2)

***********************************************************************
*Trabajo Peligroso  por horario prolongado TFP+tsnr (15 a 17) 
***********************************************************************
*suma todas las actividades de modulo TH 
foreach i of numlist 1/12 77 {
egen t`i'=rsum(min`i' hrs`i')	//suma horas y minutos por dia
gen tt_h`i'=t`i'*a14_`i'_dias	//multiplica por veces a la semana
}
egen tiempohm=rsum(t1 t2 t3 t4 t5 t6 t7 t8 t9 t10 t11 t12 t77), missing 										//th al dia 
egen tiempohm2=rsum(tt_h1 tt_h2 tt_h3 tt_h4 tt_h5 tt_h6 tt_h7 tt_h8 tt_h9 tt_h10 tt_h11 tt_h12 tt_h77), missing //th a la semana 

egen TFP_TSNR =rsum(tt_e tt_h1 tt_h2 tt_h3 tt_h4 tt_h5 tt_h6 tt_h7 tt_h8 tt_h9 tt_h10 tt_h11 tt_h12 tt_h77) if edad_grupo==3 , missing	//suma modulo AE y TH

gen 	ti_hpc=0 if nna_selec==1 & edad_grupo==3		//Trabajo Infantil por horario prolongado conjunto TFP + TSNRP (15 a 17)
replace ti_hpc=1 if TFP_TSNR>30 & TFP_TSNR!=. & tp4c!=1	//Trabajo Infantil por horario prolongado conjunto TFP + TSNRP (15 a 17)
*label
label variable ti_hpc "Trabajo Infantil por horario prolongado conjunto TFP + TSNRP (15 a 17)"
label values ti_hpc ti_hpc

***********************************************************************
*D) TRABAJO INFANTIL (5 a 17) 
***********************************************************************
*TRABAJO INFANTIL 
gen ti=.
replace ti=0 if nna_selec==1
replace ti=1 if (ti_tbem==1|ti_tp==1|tp1_tsnrp==1|tp4_tsnrp==1|tp_7tsnrp==1|ti_hpc==1) 
*label
label variable ti "Trabajo infantil general"
label values ti ti

*TRABAJO en la Frontera de Produccion (TFP)
gen 	tfp=1 if (inrange(ocupacion,1,2)|inrange(autoconsumo_b,1,2)|inrange(voluntario_b,1,2)) | ti_tbem==1
replace tfp=0 if nna_selec==1 & tfp==. 
label variable tfp "Trabajo en la frontera de producción (TFP)"
label values tfp tfp

*Trabajo de servicios no remunerado (TSNR)
gen 	tsnr=0 if nna_selec==1 & (tsnr1==. | tsnr2==.)
replace tsnr=1 if nna_selec==1 & (tsnr1==1 | tsnr2==1)
replace tsnr=1 if n11_1==1 //5-8
*label 
label variable tsnr "Trabajo de servicios no remunerado (TSNR)"
label values tsnr tsnr

*TRABAJO INFANTIL en FP
gen 	ti_tfp=.
replace ti_tfp=0 if nna_selec==1
replace ti_tfp=1 if ((ti_tp==1|tp_4==1|tp_7==1) & edad_grupo==3) | ti_tbem==1
*label
label variable ti_tfp "Trabajo Infantil por trabajo en la frontera de producción"
label values ti_tfp ti_tfp

*TRABAJO INFANTIL TSNRP 
gen ti_tsnrp=.
replace ti_tsnrp=0 if nna_selec==1
replace ti_tsnrp=1 if (tp4_tsnrp==1|tp1_tsnrp==1|tp_7tsnrp==1)
*label
label variable ti_tsnrp "Trabajo Infantil por TSNR y peligroso"
label values ti_tsnrp ti_tsnrp

*por que trabajan
egen aux1=rowmean(n14 a17)
egen aux2=rowmean(n30 a52)

*por que trabaja fp
gen pqt=.
replace pqt=1 if inlist(aux2,1,2) 	//Para ayudar con los gastos de su casa o a su familia en su trabajo
replace pqt=2 if inlist(aux2,3) 	//Para tener su propio dinero
replace pqt=3 if inlist(aux2,5,6) 	//Porque le gusta, entretiene o para no aburrirse
replace pqt=4 if inlist(aux2,4,7,8,9,10,77) 	//Otros 
label variable pqt "Por que trabaja"
label define pqt 1 "Para ayudar con los gastos de su casa o a su familia en su trabajo" 2 "Para tener su propio dinero" 3 "Porque le gusta, entretiene o para no aburrirse" 4 "Otros"
label values pqt pqt
*-Se agruparon las categorías de respuesta, Categoría 1 incluye respuestas 1 y 2.

*por que trabajo tsnr
gen pqh=.
replace pqh=1 if inlist(aux1,1) 	//Para ayudar a su familia o cooperar en la casa
replace pqh=2 if inlist(aux1,2,6) 	//Porque lo(a) mandan o es su deber
replace pqh=3 if inlist(aux1,7,8) 	//Porque le gusta o le entretiene 
replace pqh=4 if inlist(aux1,3,4,5,9,77) //Otros. Porque hay personas enfermos o con discapacidad, sus papas trabajan o no hay nadie más, para obtener permisos
label variable pqh "Por que realiza trabajo no remunerado de servicios "
label define pqh 1 "Para ayudar a su familia o cooperar en la casa" 2 "Porque lo(a) mandan o es su deber" 3 "Porque le gusta o le entretiene" 4 "Otros"
label values pqh pqh

drop aux*